#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

// funkcija za poredenje radi qsort
int cmp(const void *a, const void *b) {
    ll x = *(ll*)a;
    ll y = *(ll*)b;
    if (x < y) return -1;
    if (x > y) return 1;
    return 0;
}

// funkcija koja broji sve parove istih vrednosti u nizu
ll count_pairs(ll *a, int n) {
    qsort(a, n, sizeof(ll), cmp);

    ll res = 0;
    for (int i = 0; i < n; ) {
        int j = i;
        while (j < n && a[j] == a[i]) j++;
        ll k = j - i;
        res += k * (k - 1) / 2;  // svaki par se broji jednom
        i = j;
    }
    return res;
}

int main() {
    int n;
    scanf("%d", &n);

    ll *xs  = malloc(n * sizeof(ll)); // x koordinata
    ll *ys  = malloc(n * sizeof(ll)); // y koordinata
    ll *sum = malloc(n * sizeof(ll)); // x + y dijagonala
    ll *dif = malloc(n * sizeof(ll)); // x - y dijagonala

    for (int i = 0; i < n; i++) {
        ll x, y;
        scanf("%lld %lld", &x, &y);
        xs[i]  = x;
        ys[i]  = y;
        sum[i] = x + y;
        dif[i] = x - y;
    }

    ll ans = 0;
    ans += count_pairs(xs, n);   // Istok–Zapad (isto x)
    ans += count_pairs(ys, n);   // Sever–Jug (isto y)
    ans += count_pairs(sum, n);  // N–E i S–W (x+y dijagonala)
    ans += count_pairs(dif, n);  // N–W i S–E (x-y dijagonala)

    printf("%lld\n", ans);

    free(xs);
    free(ys);
    free(sum);
    free(dif);

    return 0;
}